package graphicalUserInterface;
 
import datasource.InMemoryDataSource;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import products.WritingImplement;

public class B_InsertingData extends JPanel {
    
    //The datasource that we will be using
    private static InMemoryDataSource datasource = new InMemoryDataSource();
    //Has to be this specific implementation as only this implementation gives us access to the lists.
    //We will also be using a JFrame for the window (as before)
    private static JFrame frame;
    //and a JTable to display our data 
    private static JTable table;
    //and a JScrollpane to enable us to scroll through large amounts of data.
    private static JScrollPane scrollPane;
 
    public B_InsertingData() {
        
        //Populate the data with the "Demo" price list.
        PriceListTableModel data =new PriceListTableModel(datasource.retrieveList("Demo"));
 
        //Build a new table based on our data.
        table = new JTable(data);
        //Set the size of the table and make it scrollable if our data doesn't fit
        table.setPreferredScrollableViewportSize(new Dimension(1000, 140));
        //Fill out the whole visable region of this table.
        table.setFillsViewportHeight(true);
 
        //Put our table in the scrollpane.
        scrollPane = new JScrollPane(table);
        //and add the scroll pane to this panel.
        add(scrollPane);
    }
 
    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Create and set up the window.
        frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
 
        //Create an instance of this JPanel that we have been defining.
        //You must create a panel if you want your window (JFrame) to display anything.
        //This is why the JPanel is often referred to as the content pane.
        B_InsertingData newContentPane = new B_InsertingData();
        newContentPane.setOpaque(true); //content panes must be opaque if you want to view it.
        frame.setContentPane(newContentPane);//assign this content pane (JPanel) to our window (JFrame)
 
        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }
 
    public static void main(String[] args) {
        //Add some price lists to our datasource before we start
        datasource.saveList("Empty",datasource.retrieveList("Demo").filterList(i->false));
        datasource.saveList("Writing Implements",datasource.retrieveList("Demo").filterList(i->i instanceof WritingImplement));
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}

